<?php


$options = array(
	'colormag_enable_accessibility'             => array(
		'title'   => esc_html__( 'Enable Accessibility', 'colormag' ),
		'default' => false,
		'type'    => 'customind-toggle',
		'section' => 'colormag_accessibility_section',
	),
	'colormag_accessibility_divider_subtitle'   => array(
		'type'    => 'customind-divider',
		'variant' => 'dashed',
		'section' => 'colormag_accessibility_section',
	),
	'colormag_accessibility_global_style'       => array(
		'default' => 'dotted',
		'type'    => 'customind-select',
		'title'   => esc_html__( 'Global Highlight', 'colormag' ),
		'section' => 'colormag_accessibility_section',
		'choices' => array(
			'none'   => esc_html__( 'None', 'colormag' ),
			'solid'  => esc_html__( 'Solid', 'colormag' ),
			'double' => esc_html__( 'Double', 'colormag' ),
			'dashed' => esc_html__( 'Dashed', 'colormag' ),
			'dotted' => esc_html__( 'Dotted', 'colormag' ),
		),
	),
	'colormag_global_accessibility_color_group' => array(
		'type'         => 'customind-color-group',
		'title'        => esc_html__( 'Color', 'colormag' ),
		'section'      => 'colormag_accessibility_section',
		'sub_controls' => apply_filters(
			'colormag_accessibility_color_controls',
			array(
				'colormag_global_accessibility_color' => array(
					'default' => '',
					'type'    => 'customind-color',
					'title'   => esc_html__( 'Normal', 'colormag' ),
					'section' => 'colormag_accessibility_section',
				),
			)
		),
	),
	'colormag_accessibility_border_divider'     => array(
		'type'    => 'customind-divider',
		'variant' => 'dashed',
		'section' => 'colormag_accessibility_section',
	),
	'colormag_input_accessibility_style'        => array(
		'default' => 'dotted',
		'type'    => 'customind-select',
		'title'   => esc_html__( 'Input Highlight', 'colormag' ),
		'section' => 'colormag_accessibility_section',
		'choices' => array(
			'none'   => esc_html__( 'None', 'colormag' ),
			'solid'  => esc_html__( 'Solid', 'colormag' ),
			'double' => esc_html__( 'Double', 'colormag' ),
			'dashed' => esc_html__( 'Dashed', 'colormag' ),
			'dotted' => esc_html__( 'Dotted', 'colormag' ),
		),
	),
	'colormag_input_accessibility_color_group'  => array(
		'type'         => 'customind-color-group',
		'title'        => esc_html__( 'Color', 'colormag' ),
		'section'      => 'colormag_accessibility_section',
		'sub_controls' => apply_filters(
			'colormag_accessibility_color_controls',
			array(
				'colormag_input_accessibility_color' => array(
					'default' => '',
					'type'    => 'customind-color',
					'title'   => esc_html__( 'Normal', 'colormag' ),
					'section' => 'colormag_accessibility_section',
				),
			)
		),
	),
);

colormag_customind()->add_controls( $options );
